local t = Def.ActorFrame {};
-- A very useful table...
local eval_lines = {
	"W1",
	"W2",
	"W3",
	"W4",
	"W5",
	"Miss",
	"Held",
	"MaxCombo"
}

-- And a function to make even better use out of the table.
local function GetJLineValue(line, pl)
	if line == "Held" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetHoldNoteScores("HoldNoteScore_Held")
	elseif line == "MaxCombo" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):MaxCombo()
	else
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetTapNoteScores("TapNoteScore_" .. line)
	end
	return "???"
end

-- #################################################
-- That's enough functions; let's get this done.


t[#t+1] = mid_pane

-- #################################################
-- Player stats and labels 
if GAMESTATE:IsHumanPlayer(PLAYER_1) then 
	local p1evalx = SCREEN_CENTER_X-420
	local p1evaly = SCREEN_TOP+125
	local eval_offset = 44
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetGrade()

	--Grade pane P1
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.02;linear,0.1;diffusealpha,1;addx,20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_grade", "pane p1")) .. {
			InitCommand=cmd(horizalign,left;x,p1evalx;y,p1evaly);
		};
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=cmd(zoom,1;horizalign,center;x,p1evalx+100;y,p1evaly-13);
			OnCommand=cmd(zoom,0.75;diffusealpha,0;sleep,0.8;smooth,0.3;zoom,1;diffusealpha,1);
		},
		-- Stage award P1
		LoadFont("_celestia 20px") .. {
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);horizalign,center;x,p1evalx+100;y,p1evaly+20;zoom,1.0;diffuse,ColorLightTone( PlayerColor(PLAYER_1) );diffusetopedge,color("#FFFFFF");playcommand,"Set";);
			OnCommand=cmd(visible, not STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetFailed();diffusealpha,0;zoom,0.8;sleep,0.8;smooth,0.1;diffusealpha,1;zoomx,0.8,zoomy,1.0;smooth,0.2;zoom,0.75;);
			SetCommand=function(self)
			  if STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward() then
				self:settext(THEME:GetString( "StageAward", ToEnumShortString(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetStageAward())) );
			  end
			end;
		};
	};
	
	-- P1 Difficulty Display
	if not GAMESTATE:IsCourseMode() then	
	t[#t+1] = LoadFont("StepsDisplay description") .. { 
			  InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,1;horizalign,center;x,p1evalx+100;y,p1evaly+41);
			  OnCommand=cmd(playcommand,"Set";diffusealpha,0;zoom,0.75;sleep,0.2;smooth,0.1;diffusealpha,1;zoomx,1.0,zoomy,0.8;smooth,0.1;zoom,0.75;);
			  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
			  CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
			  TransitionCommand=cmd(playcommand,"Set";); 
			  ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set";); 
			  SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP1 ~= nil then
						local st = stepsP1:GetStepsType();
						local diff = stepsP1:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)) .. "  " .. stepsP1:GetMeter());
						self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
						self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			  end	
		};
	end
	
	-- FC Badge P1
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(horizalign,center;x,p1evalx+195;y,p1evaly-13;);
		OnCommand=cmd(visible, not STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetFailed();zoom,0;diffusealpha,0;sleep,0.8;decelerate,0.3;zoom,0.8;diffusealpha,1;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);

		LoadActor("_w3badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};

	
		LoadActor("_w2badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
		
		LoadActor("_w1badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
	};	

		LoadActor("_macguffin") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true):diffusealpha(0):sleep(1.4):smooth(0.4):diffusealpha(0.5):smooth(2):diffusealpha(0);
					else
					self:visible(false)
				end;
			end;
		};		
	};
	
	-- Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*i;linear,0.1;diffusealpha,1;addx,20;);
		OffCommand=cmd(sleep,0.05*i;decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			InitCommand=cmd(horizalign,left;x,p1evalx;y,p1evaly+eval_offset+spacing;);
		};
		LoadFont("_celestia 20px") .. {
			InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,JudgmentLineToColor(cur_line);diffusebottomedge,color("#BFD5F7");x,p1evalx+8;y,p1evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_troika 24px") .. {
			InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));strokecolor,ColorDarkTone(JudgmentLineToColor(cur_line));x,p1evalx+190;y,p1evaly+eval_offset+spacing-1);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_1))
			end,
		};
	};
	end;
		
		local p1machrec = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):GetMachineHighScoreIndex();
		local p1persrec = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):GetPersonalHighScoreIndex();
		local p1disqual = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):IsDisqualified();

		-- Score P1
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p1evalx+100;y,p1evaly+eval_offset+23*9;horizalign,right);
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,20);
		OffCommand=cmd(sleep,0.05*9;decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. { };
			-- Normal Hybrid Scoring
			LoadFont("Common Normal") .. {
				Condition=not PREFSMAN:GetPreference("PercentageScoring");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"SCORE";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=not PREFSMAN:GetPreference("PercentageScoring");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetScore())
				end;
			};
			-- Percentage Scoring
			LoadFont("Common Normal") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and not PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"PERCENT";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and not PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addy,-1;addx,90);
				OnCommand=function(self)
					local p1percent = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPercentDancePoints()
					self:settext(FormatPercentScore(p1percent))
				end;
			};
			-- Dance Points Scoring
			LoadFont("Common Normal") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"POINTS";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(tostring(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetActualDancePoints()) .. "/" .. tostring(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPossibleDancePoints()))
				end;
			};	
		};
		
		-- Machine and Profile Records
		t[#t+1] = Def.ActorFrame {
			InitCommand=cmd(x,p1evalx+100;y,p1evaly+eval_offset+23*10;horizalign,right);
			OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*10;linear,0.1;diffusealpha,1;addx,20);
			OffCommand=cmd(sleep,0.05*10;decelerate,0.3;diffusealpha,0;addx,-20;);
			LoadActor(THEME:GetPathG("_eval", "line p1")) .. {	};
			LoadFont("_troika 24px") .. {
				Condition=p1machrec ~= -1 and p1disqual == false;
				InitCommand=cmd(horizalign,left;zoom,0.75;zoomx,0.65;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"MACHINE";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p1machrec ~= -1 and p1disqual == false;
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addy,-1;addx,-12);
				OnCommand=function(self)
					self:settextf("#%s", p1machrec +1)
				end;
			};
			LoadFont("_troika 24px") .. {
				Condition=p1persrec ~= -1 and p1disqual == false;
				InitCommand=cmd(horizalign,left;zoom,0.75;zoomx,0.65;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"PERSONAL";addx,3;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p1persrec ~= -1 and p1disqual == false;
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addy,-1;addx,90);
				OnCommand=function(self)
					self:settextf("#%s", p1persrec +1)
				end;
			};
			LoadFont("_troika 24px") .. {
				Condition=p1machrec == -1 and p1persrec == -1 and p1disqual == false;
				InitCommand=cmd(horizalign,center;zoom,0.75;diffuse,color("#BFD5F7");diffusealpha,0.5;settext,"NO RECORD";addx,0;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p1disqual == true;
				InitCommand=cmd(horizalign,center;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor("JudgmentLine_Miss"));strokecolor,ColorDarkTone(JudgmentLineToColor("JudgmentLine_Miss"));settext,"DISQUALIFIED!";addx,0;addy,-1);
			};
		};
		-- Player Mods used
		t[#t+1] = Def.ActorFrame {
			InitCommand=cmd(x,p1evalx+100;y,p1evaly+eval_offset+23*11;horizalign,right);
			OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*11;linear,0.1;diffusealpha,1;addx,20);
			OffCommand=cmd(sleep,0.05*11;decelerate,0.3;diffusealpha,0;addx,-20;);
			LoadActor(THEME:GetPathG("_eval", "line p1")) .. {	};
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,center;zoom,0.5;maxwidth,370;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");addx,0;addy,-1);
				OnCommand=function(self)
					self:settext(GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptionsString(0))
				end;
			};
		};
end;

if GAMESTATE:IsHumanPlayer(PLAYER_2) then 
	local p2evalx = SCREEN_CENTER_X+170+81-31
	local p2evaly = SCREEN_TOP+125
	local eval_offset = 44
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetGrade()

		
	-- Grade pane P2
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.02;linear,0.2;diffusealpha,1;addx,-20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor(THEME:GetPathG("_grade", "pane p2")) .. {
			InitCommand=cmd(horizalign,left;x,p2evalx;y,p2evaly);
		};
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=cmd(zoom,0.7;horizalign,center;x,p2evalx+100;y,p2evaly-13);
			OnCommand=cmd(zoom,0.75;diffusealpha,0;sleep,0.8;smooth,0.3;zoom,1;diffusealpha,1);
		},
		-- Stage award P2
		LoadFont("_celestia 20px") .. {
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);horizalign,center;x,p2evalx+100;y,p2evaly+20;zoom,1.0;diffuse,ColorLightTone( PlayerColor(PLAYER_2) );diffusetopedge,color("#FFFFFF");playcommand,"Set";);
			OnCommand=cmd(visible, not STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetFailed();diffusealpha,0;zoom,0.8;sleep,0.8;smooth,0.1;diffusealpha,1;zoomx,0.8,zoomy,1.0;smooth,0.2;zoom,0.75;);
			SetCommand=function(self)
			  if STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward() then
				self:settext(THEME:GetString( "StageAward", ToEnumShortString(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetStageAward())) );
			  end
			end;
		};
	};
	
		-- p2 Difficulty Display
	if not GAMESTATE:IsCourseMode() then	
	t[#t+1] = LoadFont("StepsDisplay description") .. { 
			  InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,1;horizalign,center;x,p2evalx+100;y,p2evaly+41);
			  OnCommand=cmd(playcommand,"Set";diffusealpha,0;zoom,0.75;sleep,0.2;smooth,0.1;diffusealpha,1;zoomx,1.0,zoomy,0.8;smooth,0.1;zoom,0.75;);
			  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
			  CurrentStepsp2ChangedMessageCommand=cmd(playcommand,"Set";); 
			  TransitionCommand=cmd(playcommand,"Set";); 
			  ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set";); 
			  SetCommand=function(self)
				stepsp2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsp2 ~= nil then
						local st = stepsp2:GetStepsType();
						local diff = stepsp2:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)) .. "  " .. stepsp2:GetMeter());
						self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
						self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			  end	
		};
		
	end
	
	-- FC Badge P2
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(horizalign,center;x,p2evalx+4;y,p2evaly-13;);
		OnCommand=cmd(visible, not STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetFailed();zoom,0;diffusealpha,0;sleep,0.8;decelerate,0.3;zoom,0.8;diffusealpha,1;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor("_w3badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};

	
		LoadActor("_w2badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
		};
		
		LoadActor("_w1badge") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true);
					else
					self:visible(false)
				end;
			end;
			OffCommand=cmd(smooth,0.2;zoom,1.1;diffusealpha,0;);
	};	

		LoadActor("_macguffin") .. {
			OnCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true):diffusealpha(0):sleep(1.4):smooth(0.4):diffusealpha(0.5):smooth(2):diffusealpha(0);
					else
					self:visible(false)
				end;
			end;
		};		
	};
	
	--Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*i;linear,0.1;diffusealpha,1;addx,-20;);
		OffCommand=cmd(sleep,0.05*i;decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			InitCommand=cmd(horizalign,left;x,p2evalx;y,p2evaly+eval_offset+spacing;);
		};
		LoadFont("_celestia 20px") .. {
			InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,JudgmentLineToColor(cur_line);diffusebottomedge,color("#BFD5F7");x,p2evalx+8;y,p2evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_troika 24px") .. {
			InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));strokecolor,ColorDarkTone(JudgmentLineToColor(cur_line));x,p2evalx+190;y,p2evaly+eval_offset+spacing-1);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_2))
			end,
		};
	};
	end;
	
		local p2machrec = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):GetMachineHighScoreIndex();
		local p2persrec = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):GetPersonalHighScoreIndex();
		local p2disqual = STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):IsDisqualified();
		-- Score P2
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*9;horizalign,right);
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,-20);
		OffCommand=cmd(sleep,0.05*9;decelerate,0.3;diffusealpha,0;addx,20;);	
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. { };
			-- Normal Hybrid Scoring
			LoadFont("Common Normal") .. {
				Condition=not PREFSMAN:GetPreference("PercentageScoring");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"SCORE";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=not PREFSMAN:GetPreference("PercentageScoring");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetScore())
				end;
			};
			-- Percentage Scoring
			LoadFont("Common Normal") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and not PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"PERCENT";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and not PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					local p2percent = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetPercentDancePoints()
					self:settext(FormatPercentScore(p2percent))
				end;
			};
			-- Dance Points Scoring
			LoadFont("Common Normal") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"POINTS";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=PREFSMAN:GetPreference("PercentageScoring") and PREFSMAN:GetPreference("DancePointsForOni");
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(tostring(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetActualDancePoints()) .. "/" .. tostring(STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetPossibleDancePoints()))
				end;
			};	
		};
		-- Machine and Profile Records
		t[#t+1] = Def.ActorFrame {
			InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*10;horizalign,right);
			OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*10;linear,0.1;diffusealpha,1;addx,-20);
			OffCommand=cmd(sleep,0.05*10;decelerate,0.3;diffusealpha,0;addx,20;);	
			LoadActor(THEME:GetPathG("_eval", "line p2")) .. { };
			LoadFont("_troika 24px") .. {
				Condition=p2machrec ~= -1 and p2disqual == false;
				InitCommand=cmd(horizalign,left;zoom,0.75;zoomx,0.65;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"MACHINE";addx,-91;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p2machrec ~= -1 and p2disqual == false;
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,-12);
				OnCommand=function(self)
					self:settextf("#%s", p2machrec +1)
				end;
			};
			LoadFont("_troika 24px") .. {
				Condition=p2persrec ~= -1 and p2disqual == false;
				InitCommand=cmd(horizalign,left;zoom,0.75;zoomx,0.65;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"PERSONAL";addx,3;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p2persrec ~= -1 and p2disqual == false;
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					self:settextf("#%s", p2persrec +1)
				end;
			};
			LoadFont("_troika 24px") .. {
				Condition=p2machrec == -1 and p2persrec == -1 and p2disqual == false;
				InitCommand=cmd(horizalign,center;zoom,0.75;diffuse,color("#FBFBAA");diffusealpha,0.5;settext,"NO NEW RECORD";addx,0;addy,-1);
			};
			LoadFont("_troika 24px") .. {
				Condition=p2disqual == true;
				InitCommand=cmd(horizalign,center;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor("JudgmentLine_Miss"));strokecolor,ColorDarkTone(JudgmentLineToColor("JudgmentLine_Miss"));settext,"DISQUALIFIED";addx,0;addy,-1);
			};
		};
		-- Player Mods used
		t[#t+1] = Def.ActorFrame {
			InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*11;horizalign,right);
			OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*11;linear,0.1;diffusealpha,1;addx,-20);
			OffCommand=cmd(sleep,0.05*11;decelerate,0.3;diffusealpha,0;addx,20;);	
			LoadActor(THEME:GetPathG("_eval", "line p2")) .. { };
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,center;zoom,0.5;maxwidth,370;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");addx,0;addy,-1);
				OnCommand=function(self)
					self:settext(GAMESTATE:GetPlayerState(PLAYER_2):GetPlayerOptionsString(0))
				end;
			};
		};
end;

return t;